#ifndef __FVOS_CONFIG_H__
#define __FVOS_CONFIG_H__


/*
   *  Object %name    : FVOS_Config.h
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:39:24 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief FVOS h file (API and structures )
   *
   *  \version 
   *  \author yevgenys
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */




/*------------------------------
    DEFINES
--------------------------------*/

/* the size of the shared area */
#define SEP_DRIVER_MESSAGE_AREA_SIZE                       (6*1024)

/* the map area include the shared area,static pool area and data pool area */
#define SEP_DRIVER_MMAP_AREA_SIZE                          (24 * 1024)


/* paramateters for Linux ioctl call */

#define SEP_DRIVER_SEND_MSG_IOCTL_CMD                       0x7300
#define SEP_DRIVER_SEND_RPLY_MSG_IOCTL_CMD                  0x7301
#define SEP_DRIVER_ALLOC_MEM_IOCTL_CMD                      0x7302
#define SEP_DRIVER_WRITE_MEM_IOCTL_CMD                      0x7303
#define SEP_DRIVER_READ_MEM_IOCTL_CMD                       0x7304     
#define SEP_DRIVER_CREATE_SYM_DMA_TABLE_CMD                 0x7305
#define SEP_DRIVER_CREATE_FLOW_DMA_TABLE_CMD                0x7306
#define SEP_DRIVER_FREE_SYM_DMA_TABLE_CMD                   0x7307
#define SEP_DRIVER_GET_STATIC_POOL_ADDR_CMD                 0x7308
#define SEP_DRIVER_SET_FLOW_ID_CMD                          0x7309
#define SEP_DRIVER_ADD_FLOW_TABLE_CMD                       0x730A
#define SEP_DRIVER_ADD_FLOW_MESSAGE_CMD                     0x730B
#define SEP_DRIVER_START_SEP                                0x730C
#define SEP_DRIVER_SEP_INIT_CMD                             0x730D
#define SEP_DRIVER_SET_API_MODE_CMD                         0x730E
#define SEP_DRIVER_END_TRANSACTION_CMD                      0x730F
#define SEP_DRIVER_REALLOC_CACHE_RESIDENT_CMD               0x7310
#define SEP_DRIVER_GET_PHYS_ADDR_OFFET_FROM_MAP_START_CMD   0x7311 
#define SEP_DRIVER_REALLOC_EXT_CACHE_CMD                    0x7312 
#define SEP_DRIVER_GET_TIME_CMD                             0x7313 

/* maximum message of the add tables in words */
#define FVOS_MAX_ADD_MESSAGE_LENGTH_IN_WORDS    11

/* maximum message of the add tables in bytes */
#define FVOS_MAX_ADD_MESSAGE_LENGTH_IN_BYTES    (FVOS_MAX_ADD_MESSAGE_LENGTH_IN_WORDS << 2)  

/* default flow id */
#define FVOS_DEFAULT_FLOW_ID                    0xFFFFFFFF

/* number of flows */
#define FVOS_NUM_FLOWS                          4

/*
 */
typedef struct _FVOS_Driver_Ioctl_Params_t
{
  union
  {
    struct 
    {
      /* offset of the allocation from the first mapped address */
      DxUint32_t offset;

      /* physical address of allocated space */
      DxUint32_t phys_address;

      /* number of bytes to allocate */
      DxUint32_t num_bytes;
    }fvos_driver_alloc_t;

    struct
    {
      /* application space address */
      DxUint32_t app_address;

      /* address of the data pool */
      DxUint32_t datapool_address;

      /* number of bytes to write */
      DxUint32_t num_bytes;
    }fvos_driver_write_t;

    struct
    {
      /* application space address */
      DxUint32_t app_address;

      /* address of the data pool */
      DxUint32_t datapool_address;

      /* number of bytes to read */
      DxUint32_t num_bytes;
      
    }fvos_driver_read_t;

    struct
    {
      /* address value of the data in */ 
      DxUint32_t  app_in_address;
          
      /* size of data in */
      DxUint32_t  data_in_size;
          
      /* address of the data out */
      DxUint32_t  app_out_address;
          
      /* the size of the block of the operation - if needed, every table will be modulo this parameter */
      DxUint32_t  block_size;
          
      /* the physical address of the first input DMA table */
      DxUint32_t  in_table_address;
          
      /* number of entries in the first input DMA table */
      DxUint32_t  in_table_num_entries;
          
      /* the physical address of the first output DMA table */
      DxUint32_t  out_table_address;
      
      /* number of entries in the first input DMA table */
      DxUint32_t  out_table_num_entries;
          
      /* data in the first input table */
      DxUint32_t  table_data_size;
      
    }fvos_driver_build_sym_table_t; 

  	struct 
  	{
  	  /* flow type */
  	  DxUint32_t  flow_type;
  	  
  	  /* flag for input output */
        DxUint32_t  input_output_flag;
  	      
  	  /* address value of the data in */ 
        DxUint32_t  virt_buff_data_addr;
  	      
  	  /* size of data in */
        DxUint32_t  num_virtual_buffers;
  	      
  	  /* the physical address of the first input DMA table */
        DxUint32_t  first_table_addr;
  	      
  	  /* number of entries in the first input DMA table */
        DxUint32_t  first_table_num_entries;
  	      
  	  /* data in the first input table */
        DxUint32_t  first_table_data_size;
  	  
  	}fvos_driver_build_flow_table_t;

  	struct
  	{
  	  /* flow id  */
  	  DxUint32_t  flow_id;
  	      
  	  /* flag for input output */
  	  DxUint32_t  input_output_flag;
  	      
  	  /* address value of the data in */ 
  	  DxUint32_t  virt_buff_data_addr;
  	      
  	  /* size of data in */
  	  DxUint32_t  num_virtual_buffers;
  	      
  	  /* address of the first table */
  	  DxUint32_t  first_table_addr;
  	      
  	  /* number of entries in the first table */
  	  DxUint32_t  first_table_num_entries;
  	      
  	  /* data size of the first table */
  	  DxUint32_t  first_table_data_size;
  	      
  	}fvos_driver_add_flow_table_t;

  	struct
  	{
  	  /* flow id to set */
  	  DxUint32_t  flow_id;
  	  
  	}fvos_driver_set_flow_id_t;

  	struct
  	{
  	  /* flow id to set */
  	  DxUint32_t  flow_id;
  	  
  	  /* message size in bytes */
  	  DxUint32_t  message_size_in_bytes;
  	  
  	  /* address of the message */
  	  DxUint32_t  message_address;
  	  
  	}fvos_driver_add_message_t;


    struct 
  	{
  	  /* start address of the message */
  	  DxUint32_t  message_addr;
  	  
  	  /* size of message in words */
  	  DxUint32_t  message_size_in_words;
  	  
  	  /* start address in the sep sram */
  	  DxUint32_t  sep_sram_addr;
  	  
  	}fvos_driver_init_t;
	
  	struct
    {
      /* base addr */
      DxUint32_t   base_addr;
    
      /* current cache address */
      DxUint32_t   cache_addr;
      
      /* cache size in bytes*/
      DxUint32_t   cache_size_in_bytes;
      
      /* current resident address */
      DxUint32_t   resident_addr;
      
      /* resident size in bytes*/
      DxUint32_t   resident_size_in_bytes;
      
      /* current dcache address */
      DxUint32_t   dcache_addr;
      
      /* resident size in bytes*/
      DxUint32_t   dcache_size_in_bytes;
      
      /* ext cache current address */
      DxUint32_t   extcache_addr;
      
      /* ext cache size in bytes*/
      DxUint32_t   extcache_size_in_bytes;
      
      /* new cache address */
      DxUint32_t   new_cache_addr;
      
      /* new resident address */
      DxUint32_t   new_resident_addr;
      
      /* new dcache address */
      DxUint32_t   new_dcache_addr;
      
      /* new resident address */
      DxUint32_t   new_shared_area_addr;
      
      /* new base address */
      DxUint32_t   new_base_addr;
      
    }fvos_driver_realloc_cache_resident_t;
    
    struct
    {   
      /* current external cache address */
      DxUint32_t   ext_cache_addr;
  
      /* external cache size in bytes*/
      DxUint32_t   ext_cache_size_in_bytes;
  
      /* new external cache address */
      DxUint32_t   new_ext_cache_addr;
 
    }fvos_driver_realloc_ext_cache_t;
      
    struct 
    {
      /* mode to set - 1 - blocking, 0 - non-blocking */
      DxUint32_t  mode;
        
    }fvos_driver_set_api_mode_t;
    
  	struct 
  	{
  	  /* physical address of the static pool */
  	  DxUint32_t physical_static_address;

  	  /* virtual address of the static pool */
  	  DxUint32_t   virtual_static_address;
  	  
  	}fvos_driver_static_pool_addr_t;
  	
  	struct 
  	{
  	  /* physical address of the static pool */
  	  DxUint32_t  physical_address;

  	  /* virtual address of the static pool */
  	  DxUint32_t  offset;
  	  
  	}fvos_driver_get_phys_addr_offset_t;
  	
  	struct
  	{
  	  /* phys address of the memory, that stores the time */
  	  DxUint32_t  time_addr;
  	  
  	  /* time value */
  	  DxUint32_t  time_val;
  	  
  	}fvos_driver_get_time_t;

  }data;  

}FVOS_Driver_Ioctl_Params_t;


#define FVOS_WriteRegister(addr,val) \
{ \
  volatile DxUint32_t  i; \
  for(i = 0; i < 1000; i++); \
  ( (*((volatile DxUint32_t*)(addr))) = (DxUint32_t)(val) ); \
}
#define FVOS_ReadRegister(addr,val) \
{ \
  volatile DxUint32_t  i; \
  for(i = 0; i < 1000; i++); \
  ( (val) = (*((volatile DxUint32_t*)(addr))) ); \
}


typedef struct _FVOS_LliEntry_t
{
  /* physical address */
  DxUint32_t  physicalAddress;
  
  /* block length */
  DxUint32_t  blockLength;
  
}FVOS_LliEntry_t;

typedef struct _FVOS_FlowData_t
{
  DxUint32_t        flowId;
  
  /* additional input tables exists */
  DxUint32_t        inputTablesFlag;
  
  /* additional output tables exists */
  DxUint32_t        outputTablesFlag;
  
  /*  address of the first input file */
  FVOS_LliEntry_t   firstInputTable;
  
  /* address of the first output table */
  FVOS_LliEntry_t   firstOutputTable;
  
  /* first input table data (num_entries+size) */
  FVOS_LliEntry_t   lastInputTable;
  
  /* first output table data (num_entries+size) */
  FVOS_LliEntry_t   lastOutputTable;
  
  /* first list of table */
  FVOS_LliEntry_t   inputTablesInProcess;
  
  /* output table in process (in sep) */
  FVOS_LliEntry_t   outputTablesInProcess;
  
  /* size of messages in bytes */
  DxUint32_t        messageSizeInBytes;
  
  /* message */
  DxUint8_t         message[FVOS_MAX_ADD_MESSAGE_LENGTH_IN_BYTES];
  
}FVOS_FlowContext_t;

#define SEP_DRIVER_PATH    "/dev/sep_sec_driver"

/*-------------------------------
  typedefs
---------------------------------*/




#endif
